<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Enugu Smart Bus Admin</title>
    <?= $this->include('common/css') ?>
    <link rel="stylesheet" href="<?= base_url('public/newadmin/styles.css') ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'primary-blue': '#1f2b6c',
                        'primary-green': '#27c840',
                        'dark-green': '#22b038',
                        'light-green': '#0f9918',
                        'dark-blue': '#001447',
                        background: '#F1F8FF',
                        overlay: '#00131ac4',
                    },
                    fontFamily: {
                        inter: ['Inter', 'sans-serif'],
                        poppins: ['Poppins', 'sans-serif'],
                    },
                },
            },
        }
    </script>
    <?= $this->include('common/headerjs') ?>
    <?= $this->renderSection('css') ?>
</head>

<body class="bg-background font-inter min-h-screen">
    <div id="overlay" class="fixed inset-0 bg-black bg-opacity-40 z-40 hidden lg:hidden"></div>
    <div class="min-h-screen flex">
        <?= $this->include('template/admin/sidebar') ?>

        <div class="flex-1 flex flex-col min-h-screen">
            <?= $this->include('template/admin/navbar') ?>
            <main class="flex-1 overflow-y-auto bg-background">
                <div class="p-4 lg:p-6 space-y-6">
                    <?= $this->include('template/admin/body') ?>
                    <?= $this->include('common/message') ?>
                    <?= $this->renderSection('content') ?>
                </div>
            </main>
        </div>
    </div>

    <?= $this->include('common/js') ?>
    <script src="<?= base_url('public/newadmin/script.js') ?>"></script>
    <?= $this->renderSection('js') ?>
</body>

</html>